//------------------------------------------------------------------------------
// File: TownHallDefense.cs
// Controls the town defense scenario, task, and its vertex methods
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Town Hall Defense Helper Functions-------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Activates the town hall defense task
////////////////////////////////////////////////////////////////////////////////
function startTownHallDefenseTasks()
{
   tsStartTask("TownHallDefense", tsGetStartingVertexes("TownHallDefense"));
}

////////////////////////////////////////////////////////////////////////////////
//! Deactivates the town hall defense task
////////////////////////////////////////////////////////////////////////////////
function endTownHallDefenseTasks()
{
   tsEndTask("TownHallDefense");
}

////////////////////////////////////////////////////////////////////////////////
//! Resets Town Hall Defense Accept
////////////////////////////////////////////////////////////////////////////////
function resetTownHallDefenseTasks()
{
   TaskModifier.strResetVertex("Campaign2Tasks", "TownhallAccept");
   TaskModifier.strMarkVertex("Campaign2Tasks", "TownhallAccept", $TSV_AVAIL);
}

////////////////////////////////////////////////////////////////////////////////
//! Rewards the player if the task is successfully completed
////////////////////////////////////////////////////////////////////////////////
function winTownHallDefense()
{
      
      // Turn off Behavior
   $AI_MONITORJOB     = true;
   $AI_MONITORHOME    = true;
   $AI_MONITORHUNGER  = true;
   
   tsModifyResource($Resource::Experience, 30, true);
   tsModifyResource($Resource::Gold, 250, true);
   SendProductionToClient(HeroCharacter, "30 experience");
   SendProductionToClient(HeroCharacter, "250 gold");
   
   // temp
   TaskModifier.strMarkVertex("Campaign2Tasks", "ReturnWithKey", $TSV_AVAIL);
   
}

//------------------------------------------------------------------------------

//-TownHallDefenseIntro Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for the starting dialog when the player first 
// enters the scenario and clearing the quest hud gui
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseIntro::onEnter(%this)
{
   Parent::onEnter(%this);
   
   InitializeQuestGui();
   // disable build button
   tsEnableCommand(BuildCmdData, false);
   
   // Send intro dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_intro", $TaskButton::Okay, "HeroCharacter");
   tsCompleteVertexes("TownHallDefense", "TownHallDefenseIntro");
}

//------------------------------------------------------------------------------

//-TownHallDefenseExplainDlg Vertex---------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for explaining the situation at the town
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseEnterTown::onExit(%this)
{
   tsSendTaskClickDlg("ID_TASKNAME_THD", "id_thd_entertownciv", $TaskButton::Okay, "TDciv3", "id_thd_entertownciv");
}
function TownHallDefenseExplainDlg::onExit(%this)
{
   tsSendTaskClickDlg("ID_TASKNAME_THD", "id_thd_entertownmay", $TaskButton::Okay, "TDmayor", "id_townhalldef_accept");
}
function TownHallDefenseSmithhelp::onExit(%this)
{
   
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_enterresponse", $TaskButton::Okay, "herocharacter", "id_thd_enterresponse");
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_enterblacksmith", $TaskButton::Okay, "TDmayor", "id_thd_enterblacksmith");
}

//-TownHallDefenseInit Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for changing object teams to the player team and
// starting the bandit disasters
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseInit::onExit(%this)
{
   Parent::onExit(%this);
   
   // Add quest logs
   tsAddQuestToTracker(true, "Town Hall Defense", "", "Defend the Town Hall from Bandits to protect the Treasure of Tailingtown.", "Reward: 250 Gold and 30 Experience");
   tsReadyQuest("Town Hall Defense");
   tsAddTaskToTracker("Town Hall Defense", "Protect the Town Hall.", "Don't let Bandits destroy the Town Hall.");
   tsAddTaskToTracker("Town Hall Defense", "Build a Bank.", "Build a Bank to protect the Treasure.");
   
   // Convert object teams and skins
   tsConvertObjTeam("TDtownhall", $OST_PLAYER);
   tsConvertObjTeam("TDwoodhut", $OST_PLAYER);
   tsConvertObjTeam("TDwell", $OST_PLAYER);
   tsConvertObjTeam("TDgoldmine", $OST_PLAYER);
   tsConvertObjTeam("TDranch", $OST_PLAYER);
   tsConvertObjTeam("TDsaloon", $OST_PLAYER);
   tsConvertObjTeam("TDwatertower", $OST_PLAYER);
   tsConvertObjTeam("TDCabin", $OST_PLAYER);
   tsConvertObjTeam("TDCabin2", $OST_PLAYER);
   tsConvertObjTeam("TDShack", $OST_PLAYER);
   tsConvertObjTeam("TDWelcomesign", $OST_PLAYER);
   tsConvertObjTeam("TDFountain", $OST_PLAYER);
   tsConvertObjTeam("TDciv1", $OST_PLAYER);
   tsConvertObjTeam("TDciv2", $OST_PLAYER);
   tsConvertObjTeam("TDciv3", $OST_PLAYER);
   tsConvertObjTeam("TDmayor", $OST_PLAYER);
   tsSkinObj("TDciv1", "base");
   tsSkinObj("TDciv2", "base");
   tsSkinObj("TDciv3", "base");
   
   // Employ civs
   slgEmployObject(TDmayor.getId(), TDtownhall.getId());
   slgEmployObject(TDciv3.getId(), TDwoodhut.getId());
   slgEmployObject(TDciv2.getId(), TDranch.getId());
   slgEmployObject(TDciv1.getId(), TDsaloon.getId());
   
   // build button
   tsEnableCommand(BuildCmdData, true);
   TownhallDisastersMed();
   
}

function TownhallDisastersMed()
{
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 120 1";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "100 120";
      disasterDroughtRate = "0 100";
      disasterEarthquakeRate = "0 120";
      disasterFamineRate = "0 120";
      disasterFireRate = "0 120";
      disasterPlagueRate = "0 100";
      disasterTornadoRate = "0 100";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 100;
      duration = 1000;
      
      fadeTime = 1;
      goldMin = 0;
      goldMax = 50;
      goldLow = 1;
      goldHigh = 5;
      lowCount = 2;
      highCount = 3;
      target    = "TDtownhall";
      
      happinessCount = -15;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
      
   LoadScenario(%scenario);      
}

//------------------------------------------------------------------------------

//-TownHallDefenseLose Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex monitors the health of the town hall and forces a restart if
// the building falls
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseLose::onExit(%this)
{
   tsRestartScenario();
}
//------------------------------------------------------------------------------

//-TownHallDefenseTreasureDlg Vertex--------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for explaining more about the treasure after
// 30 seconds have elapsed after TownHallDefenseExplainDlg completion
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseTreasureDlg::onExit(%this)
{
   Parent::onExit(%this);
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_treasure", $TaskButton::Okay, "TDciv2");
}
//------------------------------------------------------------------------------

//-TownHallDefenseBlacksmithDlg Vertex------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for explaining that you have to build a 
// blacksmith before a bank after 60 seconds have elapsed after 
// TownHallDefenseExplainDlg completion
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseBlacksmithDlg::onExit(%this)
{
   Parent::onExit(%this);
   
   tsSendTaskClickDlg("ID_TASKNAME_THD", "id_thd_blacksmith", $TaskButton::Okay, "TDciv1");
}
//------------------------------------------------------------------------------

//-TownHallDefenseBuildBlacksmith Vertex----------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for monitoring when the blacksmith has been built,
// and then upping the number of bandits in the bandit attack
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseBuildBlacksmith::onExit(%this)
{
   Parent::onExit(%this);
   
   // Reward Xp gain
   %resourceCount = rsGetResourceCount($Resource::Experience);
   if(%resourceCount < 45)
   {
      %increase = 45 - %resourceCount;
      tsModifyResource($Resource::Experience, %increase, true);
   }
   TownhallDisastersHigh();
}

function TownhallDisastersHigh()
{
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 70 1";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "100 70";
      disasterDroughtRate = "0 100";
      disasterEarthquakeRate = "0 120";
      disasterFamineRate = "0 120";
      disasterFireRate = "0 120";
      disasterPlagueRate = "0 100";
      disasterTornadoRate = "0 100";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 100;
      duration = 1000;
      
      fadeTime = 1;
      goldMin = 0;
      goldMax = 50;
      goldLow = 1;
      goldHigh = 5;
      lowCount = 3;
      highCount = 3;
      target    = "TDtownhall";
      
      happinessCount = -15;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
      
   LoadScenario(%scenario);      
}
//------------------------------------------------------------------------------

//-TownHallDefenseBuildBank Vertex----------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for monitoring when the bank has been built, and
// then completing the task in the tracker
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseBuildBank::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
      %objlist = tsGetObjListFromMsg(%msg, %param);
      %bankobjID = %objlist.getID(0);
      %bankobjID.setInternalName("TDBank");
      %bankobjID.setName("TDBank");
      
      //Final Bandit Attack
      %bandit1obj = tsCreateObj("MaleBandit", "TDBankBandit1", "2", "-156 -263", "TDBankBandit1");
      %bandit2obj = tsCreateObj("FemaleBandit", "TDBankBandit2", "2", "-146 -267", "TDBankBandit2");
      %bandit3obj = tsCreateObj("MaleBandit", "TDBankBandit3", "2", "-150 -258", "TDBankBandit3");
      %bandit4obj = tsCreateObj("FemaleBandit", "TDBankBandit4", "2", "-158 -245", "TDBankBandit4");
      %bandit5obj = tsCreateObj("MaleBandit", "TDBankBandit5", "2", "-159 -244", "TDBankBandit5");
      
      //Name Bandits
      %bandit1obj.name = "Luke Gable";
      %bandit2obj.name = "Ruby Foxworthy";
      %bandit3obj.name = "Rufus Grant";
      %bandit4obj.name = "Missy McQueen";
      %bandit5obj.name = "Cyrus Dillon";
      
      tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_bankattack", $TaskButton::More, "TDBankBandit4");
      tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_bankdefend", $TaskButton::Okay, "HeroCharacter");
      
      // Turn off Bandit spawner
      TaskModifier.strMarkVertex("TownHallDefense", "TownHallDefenseBankTimer", $TSV_AVAIL);
      
      tsAddTaskToTracker("Town Hall Defense", "Defend the Bank.", "Defend the Bank from Bandit attack.");
      tsCompleteTaskInTracker("Town Hall Defense", "Build a Bank.");
   }
}
function TownHallDefenseFinalAttack::onExit(%this)
{
   tsStartBanditAttack("TDBankBandit1", "TDBank");
   tsStartBanditAttack("TDBankBandit2", "TDBank"); 
   tsStartBanditAttack("TDBankBandit3", "TDBank"); 
   tsStartBanditAttack("TDBankBandit4", "TDBank");
   tsStartBanditAttack("TDBankBandit5", "TDBank"); 
}
function TownHallFinalAttackWin::onExit(%this)
{
   //Quest log
   tsAddTaskToTracker("Town Hall Defense", "Employ Henry at the Blacksmith", "Employ Henry Pound at the Blacksmith so he can craft you a new key.");
   tsCompleteTaskInTracker("Town Hall Defense", "Defend the Bank.");
   tsCompleteTaskInTracker("Town Hall Defense", "Protect the Town Hall.");
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_bankattackwin", $TaskButton::Okay, "HeroCharacter", "id_thd_bankattackwin");
      
}
//------------------------------------------------------------------------------

//-TownHallDefenseBankTimer Vertex----------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for waiting for a short amount of time before
// killing the bandit disaster and spawning the end bandit for dialog
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseBankTimer::onExit(%this)
{
   TownhallDisastersNone();
   // Spawn neutral bandit
   %obj = tsCreateObj(Malebandit, "petulantbandit", $OST_NEUTRAL, "0 0", "petulantbandit");
   %obj.name = "Bandit Name";
}

function TownhallDisastersNone()
{
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 3 minutes, a disaster can occur
      addDisasterNode = "0 120 0";
      disasterStack = $DisasterStack::Push;
      
      // frequency pool, respawning time
      disasterBanditRate = "0 70";
      disasterDroughtRate = "0 100";
      disasterEarthquakeRate = "0 120";
      disasterFamineRate = "0 120";
      disasterFireRate = "0 120";
      disasterPlagueRate = "0 100";
      disasterTornadoRate = "0 100";
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 0;
      duration = 1000;
      
      fadeTime = 1;
      goldMin = 0;
      goldMax = 50;
      goldLow = 1;
      goldHigh = 5;
      lowCount = 3;
      highCount = 3;
      target    = "TDtownhall";
      
      happinessCount = -15;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
      
   LoadScenario(%scenario);      
}
//------------------------------------------------------------------------------

//-TownHallDefenseEndDlg Vertex-------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for displaying end dialog
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseEndDlg::onExit(%this)
{
   // Find a town person on player team
   %teamChars   = new SLGameObjList();
   %potentChars = new SLGameObjList();
   %allChars    = slgGetServerCharacterList();
   %allChars.getTeamList($OST_PLAYER, %teamChars);
   %teamChars.getTypeList("MaleCiv", %potentChars);
   if(!%potentChars.getSize()) {
      %teamChars.getTypeList("FemaleCiv", %potentChars);
   }
   
   if(%potentChars.getSize() > 0) {
      tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_endheroask", $TaskButton::More, "HeroCharacter");
      tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_endcivexplain", $TaskButton::More, %potentChars.getID(0));
      tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_endheroresponse", $TaskButton::More, "HeroCharacter");
      tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_endbanditexclaim", $TaskButton::Okay, "petulantbandit");
   }
   else {
      tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_endheroquestion", $TaskButton::Okay, "HeroCharacter");
   }
   %teamChars.delete();
   %potentChars.delete();
   
}
// Spawn Blacksmith NPC 
function TownHallBlacksmithReturn::onExit(%this)
{
   %charobj = tsCreateObj("MaleCiv", "TDSmithy", "1", "-485 -303", "TDSmithy");
   %charobj.name ="Henry Pound";
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_smithyback", $TaskButton::More, "TDSmithy");
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_smithyhelp", $TaskButton::More, "herocharacter");
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_smithyemploy", $TaskButton::Okay, "TDSmithy", "id_thd_smithyemploy");
}
function TownHallSmithyMove::onExit(%this)
{
   tsMoveCameraToObject("TDSmithy", false);  
   tsMoveObjToTarget("TDSmithy", "TDBank");
   // Turn off Behavior
   $AI_MONITORJOB     = false;
   $AI_MONITORHOME    = false;
   $AI_MONITORHUNGER  = false;
}
// Employ TDSmithy at a Blacksmith
function TownHallSmithyFixKey::onExit(%this)
{
   tsCompleteTaskInTracker("Town Hall Defense", "Employ Henry at the Blacksmith");   
   tsSendTaskPopUpDlg("ID_TASKNAME_THD", "id_thd_smithyfixkey", $TaskButton::Okay, "TDSmithy");
   tsSendTaskClickDlg("ID_TASKNAME_THD", "id_thd_exit", $TaskButton::Accept, "HeroCharacter", "id_townhalldef_exit");
}
//------------------------------------------------------------------------------

//-TownHallDefenseExit Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex is responsible for taking the player back to the main map after
// successfully completing the scenario
////////////////////////////////////////////////////////////////////////////////
function TownHallDefenseExit::onExit(%this)
{
   %scenario = new SLScenario() {
      stack = false;
   };
   LoadScenario(%scenario, endTownHallDefenseTasks, winTownHallDefense);
   
   // complete the town hall satellite
   mapsatellite_townhall.disabled = false;
}
//------------------------------------------------------------------------------

// End TownHallDefense.cs